#include "MTEditor.h"
#include "MTUtilities.h"
#include "MTExceptions.h"
#include "MTApplication.h"
#include "AppearanceHelpers.h"
#include "MTSimpleResource.h"

//	MTEditor::MTEditor()
//	
//	constructor
MTEditor::MTEditor()
{
	basePtr = nil;
	
	isDirty = 0;
}

//	MTEditor::~MTEditor()
//	
//	destructor
MTEditor::~MTEditor()
{
	MTSimpleResourceHandler	* handler = dynamic_cast<MTSimpleResourceHandler *>(GetOwner());
	
	if(handler)
		handler->ReparseData();
}

//	void MTEditor::HandleOpenEvent(void)
//	
//	handles open event, creates ok button, cancel button, and title
void MTEditor::HandleOpenEvent(void)
{
	Rect	theRect;
	OSErr	theErr;
	char	buf[256];
	Str255	theString;
	
	SET_RECT(theRect,	theWindow->portRect.right - 5 - 58,
						theWindow->portRect.bottom - 5 - 20,
						theWindow->portRect.right - 5,
						theWindow->portRect.bottom - 5);
	
	okControl = NewControl(theWindow, &theRect, "\pOK", 1, 0, 0, 1, kControlPushButtonProc, 0);
	if(!okControl)
		throw MTException("Error creating control");
	
	theErr = SetPushButtonDefaultState(okControl, 1);
	if(theErr)
		throw MTOSException(theErr, "Error creating control");
	RegisterButtonControl(okControl);
	
	OFFSET_RECT(theRect, -(58 + 12), 0);
	
	cancelControl = NewControl(theWindow, &theRect, "\pCancel", 1, 0, 0, 1, kControlPushButtonProc, 0);
	if(!cancelControl)
		throw MTException("Error creating control");
	RegisterButtonControl(cancelControl);
	
	SET_RECT(theRect, theWindow->portRect.left + 5, theWindow->portRect.top + 5, theWindow->portRect.right - 5, theWindow->portRect.top + 5 + 14);
	
	titleControl = NewControl(theWindow, &theRect, "\p", 1, 0, 0, 0, kControlStaticTextProc, 0);
	if(!titleControl)
		throw MTException("Error creating control");
	
	std::sprintf(buf, "%s:", title->c_str());
	CopyCStringToPascal(buf, theString);
	SetStaticTextText(titleControl, theString, 1);
	
	CreateEditorControls();
}

//	void MTEditor::HandleCloseEvent(void)
//	
//	handles close event, tells derived class to clean up
void MTEditor::HandleCloseEvent(void)
{
	DestroyEditorControls();
}

//	void MTEditor::HandleContentEvent(EventRecord * theEvent, UInt32 flags)
//	
//	handles content event, calls auto-handling function
void MTEditor::HandleContentEvent(EventRecord * theEvent, UInt32 flags)
{
	#pragma unused (flags)
	
	if(AutoHandleControls(theEvent))
	{
		
	}
}

//	void MTEditor::HandleResizeEvent(SInt32 newWidth, SInt32 newHeight)
//	
//	handles resize event
void MTEditor::HandleResizeEvent(SInt32 newWidth, SInt32 newHeight)
{
	#pragma unused (newWidth)
	#pragma unused (newHeight)
}

//	void MTEditor::HandleUpdateEvent(void)
//	
//	handles update event, tells derived editor to update itself
void MTEditor::HandleUpdateEvent(void)
{
	UpdateEditorControls();
}

//	void MTEditor::HandleScrollEvent(MTWindowControlType which, SInt32 value)
//	
//	handles scroll event
void MTEditor::HandleScrollEvent(MTWindowControlType which, SInt32 value)
{
	#pragma unused (which)
	#pragma unused (value)
}

//	void MTEditor::HandleControlEvent(ControlHandle theControl, SInt16 thePart)
//	
//	handles control event, tells derivied editor about control event
void MTEditor::HandleControlEvent(ControlHandle theControl, SInt16 thePart)
{
	HandleEditorControls(theControl, thePart);
}

//	void MTEditor::HandleButtonEvent(ControlHandle theControl)
//	
//	handles a button event, tells derived editor about control event
void MTEditor::HandleButtonEvent(ControlHandle theControl)
{
	if(theControl == okControl)
	{
		WriteEditorData();
		
		gTheApp->FreeWindow(theWindow);
		
		return;
	}
	
	if(theControl == cancelControl)
	{
		gTheApp->FreeWindow(theWindow);
		
		return;
	}
	
	HandleEditorControls(theControl, kControlIndicatorPart);
}

//	void MTEditor::HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers)
//	
//	handles a key down event
void MTEditor::HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers)
{
	#pragma unused (theEvent)
	
	switch(charCode)
	{
		case kEscapeCharCode:
		{
			UInt32	ticks;
			
			HiliteControl(cancelControl, 1);
			Delay(8, &ticks);
			HiliteControl(cancelControl, 0);
			
			HandleButtonEvent(cancelControl);
		}
		break;
		
		case kEnterCharCode:
		case kReturnCharCode:
		{
			UInt32	ticks;
			
			HiliteControl(okControl, 1);
			Delay(8, &ticks);
			HiliteControl(okControl, 0);
			
			HandleButtonEvent(okControl);
		}
		break;
	}
	
	ControlHandle	focusControl;
	
	GetKeyboardFocus(theWindow, &focusControl);
	
	if(focusControl)
	{
		HandleControlKey(focusControl, keyCode, charCode, modifiers);
	}
}

void MTEditor::GetZoomSizeBounds(Rect * bounds)
{
	SET_RECT_PTR(bounds, 42, 42, 42, 42);
}

void MTEditor::GetWindowName(StringPtr theString)
{
	char	buf[256];
	
	std::sprintf(buf, "Editor: %s", title->c_str());
	CopyCStringToPascal(buf, theString);
}

void MTEditor::RecieveMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageType)
	#pragma unused (messageData)
}

UInt8 MTEditor::SupportsMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageType)
	#pragma unused (messageData)
	
	return 0;
}

void MTEditor::GetWindowSize(Rect * theRect)
{
	SET_RECT_PTR(theRect, 0, 0, 300, 100);
}

void MTEditor::GetWindowStandardSize(Rect * theRect)
{
	SET_RECT_PTR(theRect, 0, 0, 300, 100);
}

void MTEditor::GetWindowContentPadding(Rect * theRect)
{
	SET_RECT_PTR(theRect, 0, 0, 0, 0);
}

void MTEditor::HandleEditorControls(ControlHandle theControl, SInt16 thePart)
{
	#pragma unused (theControl)
	#pragma unused (thePart)
}